#!/bin/bash

# @author: Peter Bubestinger-Steindl
# @date: 2017-JAN-15
# @description:
#   Creates a set of video testfiles which all have the same file-ending,
#   but different encodings and parameters on the inside.
#
#   Used to show the "video trinity" of: container / videocodec / audiocodec.
#
# @history:
#   2019-03-12  peter_b     - Updated to contain: FLAC, Opus
#                           - Updated DV encoding.
#   2017-01-15  peter_b     - Started.


ALBUM="Video Trinity - Testset #1b"
AUTHOR="Peter B. (pb@av-rd.com)"
DATE="12.03.2019"
METADATA="-metadata album=\"$ALBUM\" -metadata encoded_by=\"$AUTHOR\" -metadata date=\"$DATE\" -metadata title=\"%s\""
LOG="ffmpeg_commands.log"

DURATION=15
FFMPEG="ffmpeg"
OVERWRITE="-n"
FFMPEG_ARGS="$OVERWRITE -f lavfi -i testsrc=size=%s:rate=%s -f lavfi -i sine=frequency=1000:sample_rate=48000 %s -c:v %s -c:a %s -t $DURATION $METADATA %s"


# Clear Logfile:
echo "" > $LOG


# ---------- Lossless:

# FFV1 / FLAC / AVI
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "25" "-aspect 4:3 -pix_fmt yuv422p" "ffv1 -g 1 -level 1" "flac -ac 4 -ar 44100" "One" "1_one.avi")
echo -e "$CMD\n" >> $LOG
eval "$CMD"


# ---------- Lossy

# DV / PCM / AVI
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "25" "-aspect 4:3 -target dv" "dvvideo -g 1" "pcm_s16le -ac 2 -ar 32000" "Two" "2_two.avi")
echo -e "$CMD\n" >> $LOG
eval "$CMD"


# XviD / MP3 / AVI
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x480" "24000/1001" "-aspect 4:3" "libxvid -b:v 850k" "libmp3lame -ar 22050 -b:a 96k" "Three" "3_three.avi")
echo -e "$CMD\n" >> $LOG
eval "$CMD"


# H.264 / AAC / MP4 (renamed to AVI)
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "2997/100" "-aspect 4:3 -pix_fmt yuv420p" "libx264" "aac -strict -2 -ac 2 -ar 48000 -b:a 160k" "Four (A)" "-f mp4 4_four_A.avi")
echo -e "$CMD\n" >> $LOG
eval "$CMD"


# H.264 / AAC / AVI #2
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x480" "30000/1001" "-aspect 4:3 -pix_fmt yuv420p" "libx264" "aac -strict -2 -ac 5 -ar 48000 -b:a 160k" "Four (B)" "4_four_B.avi")
echo -e "$CMD\n" >> $LOG
eval "$CMD"


# ProRes / PCM 24 / MOV (renamed to AVI)
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "700x576" "24" "-aspect 16:9" "prores_ks -profile:v hq" "pcm_s24be -ar 48000" "Five" "-f mov 5_five.avi")
echo -e "$CMD\n" >> $LOG
eval "$CMD"



# ---------- Uncompressed Video:

# V210 / FLAC / AVI
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "25" "-aspect 4:3" "v210" "pcm_s24le" "Six (A)" "6_six_A.avi")
echo -e "$CMD\n" >> $LOG
eval "$CMD"


# RAW YUV422P / ADPCM / AVI
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "25" "-aspect 4:3 -pix_fmt yuv422p" "rawvideo" "adpcm_ms -ar 11025" "Six (B)" "6_six_B.avi")
echo -e "$CMD\n" >> $LOG
eval "$CMD"


# RAW YUYV422 / PCM Float / AVI
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "25" "-aspect 4:3 -pix_fmt yuyv422" "rawvideo" "pcm_f32le -ar 22050" "Six (C)" "6_six_C.avi")
echo -e "$CMD\n" >> $LOG
eval "$CMD"


# RAW UYVY422 / PCM BigEndian / AVI
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "25" "-aspect 4:3 -pix_fmt uyvy422" "rawvideo" "pcm_u8 -ar 12345" "Six (D)" "6_six_D.avi")
echo -e "$CMD\n" >> $LOG
eval "$CMD"

