#!/bin/bash

video_in=$1
usage=$2
usage_type="'archive', 'access', oder 'test'"

#make archive copy
if 
    [ -f $video_in ] && [ "${usage}" == "archive" ]
then
    echo
    echo "Aktion "${usage}"-copy gewählt!"
    echo
    ffmpeg -i "$video_in" -map 0 -c:v ffv1 -level 3 -g 1 -slicecrc 1 -slices 16 -c:a pcm_s24le "${video_in%.*}.mkv"
        if [ $? == 0 ]
        then 
            echo
            echo Aktion erfolgreich!
            echo
        else
            echo
            echo FFmpeg-Befehl nicht erfolgreich!
            echo
        fi

#make access copy
elif
    [ -f $video_in ] && [ "${usage}" == "access" ]
then
    echo
    echo "Aktion "${usage}"-copy gewählt!"
    echo
    ffmpeg -i "$video_in" -map 0 -c:v libx264 -pix_fmt yuv420p -c:a aac "${video_in%.*}.mp4" 
        if [ $? == 0 ]
        then 
            echo
            echo Aktion erfolgreich!
            echo
        else
            echo
            echo FFmpeg-Befehl nicht erfolgreich!
            echo
        fi

#make test copy...
elif
    [ -f $video_in ] && [ "${usage}" == "test" ]
then
    echo
    echo "Aktion "${usage}"-copy gewählt!"
    echo
    ffmpeg -i "$video_in" -c copy -map 0 "${video_in%.*}.mov"
        if [ $? == 0 ]
        then 
            echo
            echo Aktion erfolgreich!
            echo
        else
            echo
            echo FFmpeg-Befehl nicht erfolgreich!
            echo
        fi

#error message, when input does not exist        
elif 
    [ ! -f $video_in ]
then
    echo 
    echo "$video_in existiert nicht, falscher Pfad?"
    echo
    
#error message, when input is missing
elif 
    [ "${video_in}" == "" ]
then
    echo
    echo "Bitte Syntax beachten:"
    echo
    echo "$0 VIDEO_INPUT usage"
    echo 
    echo "usage=$usage_type"
    echo

#error message, when input exists, but usage is missing 
elif 
    [ -f $video_in ] && [ "${video_in}" != "" ] && [ "${usage}" == "" ]
then
    echo
    echo "Keine Anwendung gewählt, bitte nach "$video_in" ${usage_type} eingeben!"
    echo

#error message, when input exists, but usage type is wrong
elif
    [ -f $video_in ] && [ "${video_in}" != "" ] && [ "${usage}" != "{archive,access,test}" ]
then
    echo
    echo "Unbekannte Anwendung gewählt, bitte nach "$video_in" "${usage_type}" eingeben!"
    echo
fi

