#!/bin/bash

video_in=$1
usage=$2
usage_options="archive, access"
ffmpeg="ffmpeg"
DEBUG=0


##
# Takes a string as parameter and executes it as command.
# Returns the exit value of the executed command as-is.
#
function runCmd {
    local CMD="$1"
    echo "Führe folgenden Befehl aus:"
    echo "$CMD"

    if [ $DEBUG -eq 0 ]; then
        eval "$CMD"
    fi
    return $?
}

##
# Show a message if given exit value was a success or not.
#
function checkSuccess {
    local RETVAL=$1

    echo
    if [ $RETVAL == 0 ]; then
        echo "Aktion erfolgreich!"
    else
        echo "Befehl nicht erfolgreich! (Exitcode: $RETVAL)"
    fi
    echo
}

##
# Shows information about how this program can be used and which parameters it
# requires.
#
function showHelp {
    echo
    echo "Aufrufsyntax des Programms ist wie folgt:"
    echo
    echo "$0 VIDEO_INPUT USAGE"
    echo
    echo "USAGE = $usage_options"
    echo
}


# Complain if no video was given:
if [ -z "$video_in" ]; then
    echo
    echo "Kein Videofile angegeben."
    echo
    showHelp
    exit 1
fi

# Check if source video exists:
if [ ! -f "$video_in" ]; then
    echo
    echo "Videofile '$video_in' existiert nicht, falscher Pfad?"
    echo
    exit 2
fi

# Error message, when input exists, but usage type is wrong
if [[ "$usage_options" != *"$usage"* ]]; then
    echo
    echo "Unbekannte Anwendung gewählt."
    echo "Bitte nach VIDEO_INPUT die USAGE eingeben!"
    echo
    showHelp
    exit 5
fi



# Show selected choice:
echo
echo "Aktion "${usage}"-copy gewählt!"
echo

case $usage in
    archive)
        echo "Erzeuge Archivkopie..."
        CMD="$ffmpeg -i \"$video_in\" -map 0 \
          -c:v ffv1 -level 3 -g 1 -slicecrc 1 -slices 16 \
          -c:a pcm_s24le \
          \"${video_in%.*}.mkv\""

        runCmd "$CMD"
        if ! checkSuccess $?; then exit 3; fi
        ;;

    access)
        echo "Erzeuge Ansichtskopie..."
        CMD="ffmpeg -i \"$video_in\" -map 0 \
          -c:v libx264 -pix_fmt yuv420p \
          -c:a aac \
          \"${video_in%.*}.mp4\""

        runCmd "$CMD"
        if ! checkSuccess $?; then exit 3; fi
        ;;

    test)
        ;;

    *)
        showHelp
        exit
        ;;
esac
