@echo off

SET FFMPEG=C:\ffmpeg\bin\ffmpeg.exe
SET VIDEO_IN=%1
SET ANWENDUNGSFALL=%2

IF NOT EXIST %FFMPEG% GOTO ERROR_FFmpegNotFound
echo "FFmpeg found. Continue."
IF "%ANWENDUNGSFALL%"=="archiv" GOTO MakeArchiveCopy
IF "%ANWENDUNGSFALL%"=="access" GOTO MakeAccessCopy
GOTO ERROR_UnknownAnwendungsfall

:MakeArchiveCopy
echo Archivkopie...
echo %FFMPEG% -i %VIDEO_IN% -c:v copy -c:a pcm_s16le %VIDEO_IN%.mkv
GOTO End

:MakeAccessCopy
echo Ansichtskopie...
echo %FFMPEG% -i %VIDEO_IN% -c:v libx264 -b:v 850k -an %VIDEO_IN%.mp4
GOTO End


:ERROR_FFmpegNotFound
echo FFmpeg not found at: '%FFMPEG%'. Please check path.
GOTO End

:ERROR_UnknownAnwendungsfall
echo "Unbekannter Anwendungsfall: '%ANWENDUNGSFALL%'"
echo Gültige Anwendungsfälle sind: access, archiv
GOTO End

:End
