#!/bin/bash

# @author: Peter Bubestinger-Steindl
# @date: 2017-JAN-15
# @description:
#   Creates a set of video testfiles which all have the same file-ending,
#   but different encodings and parameters on the inside.
#
#   Used to show the "video trinity" of: container / videocodec / audiocodec.


ALBUM="Video Trinity - Testset #1"
AUTHOR="Peter B. (pb@av-rd.com)"
DATE="15.01.2017"
METADATA="-metadata album=\"$ALBUM\" -metadata encoded_by=\"$AUTHOR\" -metadata date=\"$DATE\" -metadata title=\"%s\""

DURATION=2
FFMPEG="ffmpeg"
FFMPEG_ARGS="-f lavfi -i testsrc=size=%s:rate=%s -f lavfi -i sine=frequency=1000 %s -c:v %s -c:a %s -t $DURATION $METADATA %s"


# ---------- Lossless:

# FFV1 / PCM / AVI
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "25" "-aspect 4:3 -pix_fmt yuv444p" "ffv1 -g 1 -level 1" "pcm_s16le -ar 44100" "One" "1_one.avi")
echo "$CMD"
eval "$CMD"


# ---------- Lossy

# DV / PCM / AVI
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "25" "-aspect 4:3" "dvvideo -g 1" "pcm_s16le -ac 2 -ar 32000" "Two" "2_two.avi")
echo "$CMD"
eval "$CMD"


# XviD / MP3 / AVI
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "25" "-aspect 4:3" "libxvid" "libmp3lame -b:a 96k" "Three" "3_three.avi")
echo "$CMD"
eval "$CMD"


# H.264 / AAC / MP4 (renamed to AVI)
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "2997/100" "-aspect 4:3 -pix_fmt yuv420p" "libx264" "aac -strict -2 -ar 48000 -b:a 160k" "Four (A)" "4_four_A.mp4")
echo "$CMD"
eval "$CMD"
# hihihi....
mv 4_four_A.mp4 4_four_A.avi


# H.264 / AAC / AVI #2
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "30000/1001" "-aspect 4:3 -pix_fmt yuv420p" "libx264" "aac -strict -2 -ar 48000 -b:a 160k" "Four (B)" "4_four_B.avi")
echo "$CMD"
eval "$CMD"


# ---------- Uncompressed Video:

# V210 / FLAC / AVI
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "25" "-aspect 4:3" "v210" "pcm_s24le" "Five" "5_five.avi")
echo "$CMD"
eval "$CMD"


# RAW YUV422P / ADPCM / AVI
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "25" "-aspect 4:3 -pix_fmt yuv422p" "rawvideo" "adpcm_ms -ar 11025" "Six" "6_six.avi")
echo "$CMD"
eval "$CMD"


# RAW YUYV422 / PCM / AVI
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "25" "-aspect 4:3 -pix_fmt yuyv422" "rawvideo" "pcm_s16le -ar 11025" "Seven" "7_seven.avi")
echo "$CMD"
eval "$CMD"


# RAW UYVY422 / PCM / AVI
CMD=$(printf "$FFMPEG $FFMPEG_ARGS" "720x576" "25" "-aspect 4:3 -pix_fmt uyvy422" "rawvideo" "pcm_s16le -ar 11025" "Eight" "8_eight.avi")
echo "$CMD"
eval "$CMD"

