/* -LICENSE-START-
** Copyright (c) 2013 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/
#ifndef BMIO_CLIENT_H
#define BMIO_CLIENT_H

#include "bmio_driver.h"
#include "bm_locks.h"


#include <asm/atomic.h>
#include <linux/wait.h>
#include <linux/list.h>

typedef struct UserClientClassLinux* UserClientClassLinuxPtr;
typedef struct IOMemoryDescriptor* IOMemoryDescriptorPtr;
typedef struct IOMemoryMap* IOMemoryMapPtr;


struct file;
struct poll_table_struct;

struct bmio_client;
typedef struct bmio_client bmio_client_t;

typedef struct bmio_notify_list
{
	struct list_head head;
	wait_queue_head_t wait;
	bm_spinlock_t* lock;
	size_t count;
} bmio_notify_list_t;

typedef struct bmio_client_mmap
{
	bmio_client_t* cli;
	IOMemoryDescriptorPtr mem;
	IOMemoryMapPtr map;
	void* buffer;
	size_t size;
	uint32_t type;
	atomic_t ref;
} bmio_client_mmap_t;

struct bmio_client
{
	UserClientClassLinuxPtr client;

	atomic_t ref;

	bmio_notify_list_t notify;
};

bmio_client_t* bmio_client_alloc(bmio_driver_t* drv);

int bmio_client_init(bmio_client_t* cli, bmio_driver_t* drv);
void bmio_client_deinit(bmio_client_t* cli);

bmio_client_t* bmio_client_get(bmio_client_t* cli);
void bmio_client_put(bmio_client_t* cli);

int bmio_client_ioctl(bmio_client_t* cli, unsigned int cmd, unsigned long arg);

bool bmio_client_notify(bmio_client_t* cli, uint32_t type, uint32_t param1, uint32_t param2, uint32_t param3, uint32_t param4);

bool bmio_notify_add(bmio_notify_list_t* list, uint32_t type, uint32_t param1, uint32_t param2, uint32_t param3, uint32_t param4);
ssize_t bmio_notify_read(bmio_notify_list_t* list, char* buffer, size_t count);
void bmio_notify_clear(bmio_notify_list_t* list);

size_t bmio_client_notify_queue_size(bmio_client_t* cli);

int bmio_client_mmap(bmio_client_t* cli, bmio_client_mmap_t* mmap);
void bmio_client_munmap(bmio_client_t* cli, bmio_client_mmap_t* mmap);


#endif
