/* -LICENSE-START-
** Copyright (c) 2013 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/
#ifndef BM_MM_H
#define BM_MM_H

#include "bm_types.h"
#include "bm_pci.h"


typedef enum bm_dma_direction
{
	BM_MM_DMA_BIDIRECTIONAL = 0,
	BM_MM_DMA_TO_DEVICE = 1,
	BM_MM_DMA_FROM_DEVICE = 2,
	BM_MM_DMA_NONE = 3
} bm_dma_direction_t;

typedef struct bm_mm_stats
{
	atomic_t memory_mapped;
	atomic_t pages_held;
	atomic_t pages_mapped;
	atomic_t pages_vmapped;
} bm_mm_stats_t;

struct bm_user_mem;
typedef struct bm_user_mem bm_user_mem_t;

bm_user_mem_t* bm_mm_get_user_pages(void* address, vm_size_t size, bool write);
void bm_mm_put_user_pages(bm_user_mem_t* umem, bool dirty);

struct bm_mmap;
typedef struct bm_mmap bm_mmap_t;

bm_mmap_t* bm_mmap_map(bm_user_mem_t* umem, void* address, vm_size_t size, bool write);
void bm_mmap_unmap(bm_mmap_t* mmap);

vm_address_t bm_mmap_get_vaddress(bm_mmap_t* mmap);

struct sg_table;
typedef struct sg_table bm_sg_table_t;

struct scatterlist;
typedef struct scatterlist bm_sg_segment_t;

bm_sg_table_t* bm_dma_sg_from_user_pages(bm_pci_device_t* pci, bm_user_mem_t* umem);
bm_sg_table_t* bm_dma_sg_from_kernel_vmalloc(bm_pci_device_t* pci, void* addr, vm_size_t size);
int bm_dma_sg_bus_map(bm_pci_device_t* pci, bm_sg_table_t* sgTable, bm_dma_direction_t dir);
void bm_dma_sg_bus_unmap(bm_pci_device_t* pci, bm_sg_table_t* sgTable, bm_dma_direction_t dir);
bm_sg_segment_t* bm_dma_sg_bus_map_first_segment(bm_sg_table_t* sgTable, vm_address_t sgDataBaseAddr, addr64_t* segAddress, uint64_t* segSize);
bm_sg_segment_t* bm_dma_sg_bus_map_next_segment(bm_sg_segment_t* currentSeg, addr64_t* segAddress, uint64_t* segSize);
addr64_t bm_dma_sg_bus_segment(const bm_sg_table_t* sgTable, vm_address_t sgDataBaseAddr, vm_offset_t offset, uint32_t* lenLimit);

struct bm_dma_subpage;
typedef struct bm_dma_subpage bm_dma_subpage_t;

bm_dma_subpage_t* bm_dma_bus_map_kernel_subpage(bm_pci_device_t* pci, void* addr, vm_size_t size, bm_dma_direction_t dir);
void bm_dma_bus_unmap_kernel_subpage(bm_pci_device_t* pci, bm_dma_subpage_t* subpage, bm_dma_direction_t dir);
addr64_t bm_dma_bus_address_of_kernel_subpage(const bm_dma_subpage_t* subpage, void* addr, vm_offset_t offset, uint32_t* lenLimit);

vm_address_t bm_mm_phys_to_virt(addr64_t phys);

const bm_mm_stats_t* bm_mm_statistics(void);


#endif
