#ifndef BLACKMAGIC_VERSION_H
#define BLACKMAGIC_VERSION_H

#include <linux/version.h>

#ifndef RHEL_RELEASE_VERSION
	// If this isn't a RHEL kernel, ensure these checks fail
	#define RHEL_RELEASE_OR_LATER(a, b) 0
#else
	#define RHEL_RELEASE_OR_LATER(a, b) (RHEL_RELEASE_CODE >= RHEL_RELEASE_VERSION(a, b))
#endif

#define KERNEL_VERSION_OR_LATER(a, b, c) (LINUX_VERSION_CODE >= KERNEL_VERSION(a, b, c))
#define KERNEL_PATCH_VERSION_OR_LATER(a, b, c) ((LINUX_VERSION_CODE & KERNEL_VERSION(0xff, 0xff, 0)) == KERNEL_VERSION(a, b, 0) && (LINUX_VERSION_CODE & KERNEL_VERSION(0, 0, 0xff)) >= KERNEL_VERSION(0, 0, c))

#endif
