/* -LICENSE-START-
** Copyright (c) 2013 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/
#ifndef BMIO_DEVICE_H
#define BMIO_DEVICE_H

struct bmio_device;
typedef struct bmio_device bmio_device_t;

#include "bm_types.h"
#include "bm_pci.h"


#include <linux/mutex.h>

typedef struct BlackmagicIOSupervisor* BlackmagicIOSupervisorPtr;
typedef struct IOPCIDevice* IOPCIDevicePtr;


struct bmio_device
{
	bm_pci_device_t* pci;
	IOPCIDevicePtr iopci;
	BlackmagicIOSupervisorPtr supervisor;
	bool removed;

	atomic_t ref;
	struct mutex lock;
	// Don't put anything down here
};

bmio_device_t* bmio_device_alloc(struct pci_dev* pdev);
void bmio_device_remove(bmio_device_t* dev);

int bmio_device_init(bmio_device_t* dev);
void bmio_device_deinit(bmio_device_t* dev);

int bmio_device_suspend(bmio_device_t* dev);
int bmio_device_resume(bmio_device_t* dev);

bmio_device_t* bmio_device_get(bmio_device_t* dev);
void bmio_device_put(bmio_device_t* dev);

void bmio_device_pci_name(bmio_device_t* dev, char* buf, size_t len);


#endif
