/* -LICENSE-START-
** Copyright (c) 2013 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/
#ifndef BM_VERSION_H
#define BM_VERSION_H

#include <linux/version.h>

#ifndef RHEL_RELEASE_VERSION
	// If this isn't a RHEL kernel, ensure these checks fail
	#define RHEL_RELEASE_OR_LATER(a, b) 0
#else
	#define RHEL_RELEASE_OR_LATER(a, b) (RHEL_RELEASE_CODE >= RHEL_RELEASE_VERSION(a, b))
#endif

#define KERNEL_VERSION_OR_LATER(a, b, c) (LINUX_VERSION_CODE >= KERNEL_VERSION(a, b, c))
#define KERNEL_PATCH_VERSION_OR_LATER(a, b, c) ((LINUX_VERSION_CODE & KERNEL_VERSION(0xff, 0xff, 0)) == KERNEL_VERSION(a, b, 0) && (LINUX_VERSION_CODE & KERNEL_VERSION(0, 0, 0xff)) >= KERNEL_VERSION(0, 0, c))

#endif
