/* -LICENSE-START-
** Copyright (c) 2013 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/
#ifndef BM_PCI_H
#define BM_PCI_H

#include <asm/atomic.h>
#include <linux/irqreturn.h>
#include "bm_types.h"

struct pci_dev;

#define BM_PCI_IRQ_NAME_SIZE 32

typedef irqreturn_t (*bm_interrupt_handler_t)(int, void*);

typedef struct bm_pci_device
{
	struct pci_dev* pdev;
	char irq_name[BM_PCI_IRQ_NAME_SIZE];
	bm_interrupt_handler_t irq_handler;
	void* irq_data;
	atomic_t ref;
} bm_pci_device_t;

bm_pci_device_t* bm_pci_alloc(struct pci_dev* pdev);

bm_pci_device_t* bm_pci_get(bm_pci_device_t* pci);
void bm_pci_put(bm_pci_device_t* pci);

bool bm_pci_start(bm_pci_device_t* pci);
void bm_pci_stop(bm_pci_device_t* pci);

bool bm_pci_set_bus_master_enable(bm_pci_device_t* pci, bool enable);
bool bm_pci_set_memory_enable(bm_pci_device_t* pci, bool enable);

uint8_t bm_pci_bus_number(bm_pci_device_t* pci);
uint8_t bm_pci_device_number(bm_pci_device_t* pci);
uint8_t bm_pci_function_number(bm_pci_device_t* pci);

uint8_t bm_pci_read_config_u8(bm_pci_device_t* pci, int offset);
uint16_t bm_pci_read_config_u16(bm_pci_device_t* pci, int offset);
uint32_t bm_pci_read_config_u32(bm_pci_device_t* pci, int offset);

void bm_pci_write_config_u8(bm_pci_device_t* pci, int offset, uint8_t val);
void bm_pci_write_config_u16(bm_pci_device_t* pci, int offset, uint16_t val);
void bm_pci_write_config_u32(bm_pci_device_t* pci, int offset, uint32_t val);

bool bm_pci_using_msi(bm_pci_device_t* pci);

bool bm_pci_register_interrupt(bm_pci_device_t* pci, const char* name, bm_interrupt_handler_t handler, void* data);
void bm_pci_unregister_interrupt(bm_pci_device_t* pci);

bool bm_pci_map_bar(bm_pci_device_t* pci, int bar, void** addr, vm_size_t* size);
void bm_pci_unmap(bm_pci_device_t* pci, void* addr);


#endif
