/* -LICENSE-START-
** Copyright (c) 2013 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/
#ifndef BM_LOCKS_H
#define BM_LOCKS_H


/* Spin locks */
#include <linux/spinlock.h>

typedef spinlock_t bm_spinlock_t;

bm_spinlock_t* bm_spin_alloc(void);
void bm_spin_free(bm_spinlock_t* lock);

void bm_spin_lock(bm_spinlock_t* lock);
bool bm_spin_trylock(bm_spinlock_t* lock);
void bm_spin_unlock(bm_spinlock_t* lock);
void bm_spin_lock_irq(bm_spinlock_t* lock);
void bm_spin_unlock_irq(bm_spinlock_t* lock);
void bm_spin_lock_irqsave(bm_spinlock_t* lock, unsigned long* flags);
void bm_spin_unlock_irqrestore(bm_spinlock_t* lock, unsigned long flags);

/* Read/Write spin locks */
typedef rwlock_t bm_rwlock_t;

bm_rwlock_t* bm_rwlock_alloc(void);
void bm_rwlock_free(bm_rwlock_t* lock);

void bm_rwlock_read_lock(bm_rwlock_t* lock);
bool bm_rwlock_read_trylock(bm_rwlock_t* lock);
void bm_rwlock_read_unlock(bm_rwlock_t* lock);
void bm_rwlock_read_lock_irq(bm_rwlock_t* lock);
void bm_rwlock_read_unlock_irq(bm_rwlock_t* lock);
void bm_rwlock_read_lock_irqsave(bm_rwlock_t* lock, unsigned long* flags);
void bm_rwlock_read_unlock_irqrestore(bm_rwlock_t* lock, unsigned long flags);

void bm_rwlock_write_lock(bm_rwlock_t* lock);
bool bm_rwlock_write_trylock(bm_rwlock_t* lock);
void bm_rwlock_write_unlock(bm_rwlock_t* lock);
void bm_rwlock_write_lock_irq(bm_rwlock_t* lock);
void bm_rwlock_write_unlock_irq(bm_rwlock_t* lock);
void bm_rwlock_write_lock_irqsave(bm_rwlock_t* lock, unsigned long* flags);
void bm_rwlock_write_unlock_irqrestore(bm_rwlock_t* lock, unsigned long flags);


/* Basic mutex */
typedef struct mutex bm_mutex_t;

bm_mutex_t* bm_mutex_alloc(void);
void bm_mutex_free(bm_mutex_t* mutex);

void bm_mutex_lock(bm_mutex_t* mutex);
bool bm_mutex_trylock(bm_mutex_t* mutex);
void bm_mutex_unlock(bm_mutex_t* mutex);

int bm_mutex_sleep(bm_mutex_t* mutex, void* event, int state);
int bm_mutex_sleep_timeout(bm_mutex_t* mutex, void* event, int state, long timeout);
void bm_mutex_wakeup(bm_mutex_t* mutex, void* event, bool one);

/* Recursive mutex */
typedef struct bm_rmutex bm_rmutex_t;

bm_rmutex_t* bm_rmutex_alloc(void);
void bm_rmutex_free(bm_rmutex_t* mutex);

void bm_rmutex_lock(bm_rmutex_t* mutex);
bool bm_rmutex_trylock(bm_rmutex_t* mutex);
void bm_rmutex_unlock(bm_rmutex_t* mutex);
bool bm_rmutex_have_lock(const bm_rmutex_t* mutex);



#endif
