/* -LICENSE-START-
** Copyright (c) 2009 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/

#ifndef __DECKLINK_LIB_H__
#define __DECKLINK_LIB_H__


#define KMALLOC_MAX_BYTES	131072



struct dl_dma_list;
struct pci_dev;
typedef unsigned long long dl_dma_addr_t;

/* User-space memory access */
extern unsigned long __dl_copy_from_user(void *to, const void *from, unsigned long n);
extern unsigned long __dl_copy_to_user(void *to, const void *from, unsigned long n);
extern int dl_access_ok(int type, void *addr, unsigned long size);
extern void *dl_get_user_pages(void *task_ptr, void *ptr, unsigned long size, unsigned long *, int);
extern void dl_unmap_user_pages(void *ptr, unsigned long nr_pages, int flag_dirty);
extern void *dl_get_current(void);

extern int dl_flush_cache_all(void);

/* Register read/write */
extern void dl_iowrite32(unsigned int value, volatile void *addr);
extern unsigned int dl_ioread32(volatile void *addr);

/* General memory management */
extern void *dl_kmalloc(unsigned int);
extern void *dl_kzalloc(unsigned int);
extern void dl_kfree(void *);
extern void *dl_vmalloc(unsigned int);
extern void dl_vfree(void *);

void *dl_vmap(void *page_array, unsigned long page_num);
void dl_vunmap(void *address);

/* DMA Mapping */
extern struct dl_dma_list* 
dl_dma_map_user_buffer(void* page_array, unsigned long num_pages, int direction, void* pdev);
extern struct dl_dma_list* 
dl_dma_map_kernel_buffer(void *address, unsigned long size, int direction, int is_vmalloc, void* pdev);
extern dl_dma_addr_t dl_dma_get_physical_segment(struct dl_dma_list* sl, void* address, unsigned long offset, unsigned long* length);
extern void dl_dma_unmap_kernel_buffer(struct dl_dma_list* sl, int direction);

enum {
	DL_DMA_TO_DEVICE = 0,
	DL_DMA_FROM_DEVICE,
	DL_DMA_BIDIRECTIONAL
};

extern const char *DL_KERN_INFO;
extern const char *DL_KERN_WARNING;
extern const char *DL_KERN_ERR;

/* Misc Utils */
extern int dl_compare_and_swap(volatile unsigned int *, int, int);
extern unsigned int dl_bit_or_atomic(unsigned int mask, unsigned int *value);
extern int dl_printk(const char *fmt, ...);
#define dl_info(fmt, ...) dl_printk("%sblackmagic: " fmt, DL_KERN_INFO, ##__VA_ARGS__)
#define dl_warn(fmt, ...) dl_printk("%sblackmagic[WARNING]: " fmt, DL_KERN_WARNING, ##__VA_ARGS__)
#define dl_error(fmt, ...) dl_printk("%sblackmagic[ERROR]: " fmt, DL_KERN_ERR, ##__VA_ARGS__)
extern unsigned long long dl_uptime(void);
extern unsigned long long dl_get_time_us(void);
extern long long dl_to_nano_secs(unsigned long long time);
extern void dl_udelay(unsigned long);
extern void dl_msleep(unsigned long);

#define kMillisecondScale	1
extern unsigned long dl_jiffies_in_unit(long value, int unit);
extern void dl_backtrace(void);

extern unsigned int dl_strlen(const char *s);
extern char *dl_strncpy(char *s1, const char *s2, unsigned int n);
extern void *dl_memcpy(void *, const void *, unsigned int);
extern int dl_memcmp(const void *, const void *, unsigned int);
extern void *dl_memset(void *, int, unsigned int);
extern unsigned long long dl_div64(unsigned long long, unsigned long long);
extern unsigned long long dl_mod64(unsigned long long, unsigned long long);

/* PCI functions */
extern unsigned int dl_pci_read_config_dword(void *pci_dev, int offset);
extern unsigned short int dl_pci_read_config_word(void *pci_dev, int offset);
extern unsigned char dl_pci_read_config_byte(void *pci_dev, int offset);
extern int dl_pci_write_config_dword(void *pci_dev, int offset, unsigned int val);
extern int dl_pci_write_config_word(void *pci_dev, int offset, unsigned short int val);
extern int dl_pci_write_config_byte(void *pci_dev, int offset, unsigned char val);
extern void *dl_pci_map_bar(void *pci_dev, int bar);
extern void dl_pci_unmap_bar(void *address);
extern unsigned short dl_pci_get_bus_num(void *pci_dev);
extern unsigned short dl_pci_get_device_num(void *pci_dev);
extern unsigned short dl_pci_get_func_num(void *pci_dev);
extern unsigned short dl_pci_get_slot_num(void *pci_dev);
extern void dl_pci_set_bus_master(void *pci_dev);
extern bool dl_pci_supports_msi(void *pci_dev);
extern void *dl_pci_get_parent_pci_dev(void *pci_dev);

/* Locking */
struct dl_spinlock_t;
extern struct dl_spinlock_t *dl_alloc_spinlock(void);
extern void dl_free_spinlock(struct dl_spinlock_t *);
extern void dl_spin_lock_irqsave(struct dl_spinlock_t *, unsigned long *);
extern void dl_spin_unlock_irqrestore(struct dl_spinlock_t *, unsigned long);
extern void *dl_alloc_semaphore(void);
extern void dl_sema_down(void *);
extern int dl_sema_down_trylock(void *);
extern int dl_sema_down_timeout(void *, unsigned long timeout, unsigned int *);
extern void dl_sema_up(void *);
extern void dl_sema_free(void *);

#define THREAD_INTERRUPTED	0
#define THREAD_AWAKENED		1
#define THREAD_TIMED_OUT	2
#define THREAD_WAITING		3

typedef int wait_result_t;
typedef void*  thread_t;
typedef void (*thread_continue_t)(void *, wait_result_t);

/* Threads */
extern int dl_kernel_thread_start(thread_continue_t, void *, thread_t*);

/* Wait Queue API */
struct dl_wait_queue_entry_t
{
	void *addr;
	struct dl_wait_queue_head_t *queue;
};

struct dl_wait_queue_head_t;
struct dl_wait_queue_head_t *dl_alloc_waitqueue(void);
void dl_free_waitqueue(struct dl_wait_queue_head_t *);
extern void *dl_get_wait_queue_ptr(struct dl_wait_queue_head_t *);
extern void dl_set_wait_queue_event(struct dl_wait_queue_head_t *);
extern void dl_clear_wait_queue_event(struct dl_wait_queue_head_t *);
extern int dl_get_wait_event_state(struct dl_wait_queue_head_t *);
extern unsigned int dl_poll_wait(void *filp, struct dl_wait_queue_head_t *queue, void *wait, int write);
extern void dl_destroy_wait_queue_cache(void);

/* FPU save/restore */
extern void dl_kernel_fpu_begin(void);
extern void dl_kernel_fpu_end(void);

extern unsigned int dl_hash_string(const char* str, unsigned int bits);
extern int dl_strcmp(const char* str1, const char *str2);

extern void dl_schedule(void);

#endif
