/* -LICENSE-START-
** Copyright (c) 2009 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/

#ifndef __DECKLINK_DRIVER_H_
#define __DECKLINK_DRIVER_H_

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/pci.h>
#include <linux/interrupt.h>
#include <linux/init.h>
#include <linux/vmalloc.h>
#include <linux/ioctl.h>
#include <linux/cdev.h>
#include <linux/miscdevice.h>
#include <linux/list.h>
#include <linux/wait.h>
#include <linux/spinlock.h>
#include <linux/tty.h>

#include "blackmagic_version.h"
#include "blackmagic_lib.h"
#include "blackmagic_iml.h"

#define BLACKMAGIC_SERIAL_MINORS	32
#define BLACKMAGIC_HW_TX_SIZE		16
#define BLACKMAGIC_SERIAL_BUFFER_SIZE	PAGE_SIZE

enum blackmagic_serial_open_states {
	PORT_CLOSED = 0,
	PORT_OPEN_IOCTL,
	PORT_OPEN_TTY,
};

struct blackmagic_serial_buffer
{
	unsigned char data[BLACKMAGIC_SERIAL_BUFFER_SIZE];
	unsigned char *end;
	unsigned char *next;
	unsigned char *last;
	unsigned int available_bytes;
};

struct blackmagic_serial 
{
#if KERNEL_VERSION_OR_LATER(3, 8, 0)
	struct tty_port port;
#else
	struct tty_struct *tty;
#endif
	enum blackmagic_serial_open_states open_state;
	atomic_t tx_interrupt_pending;
	spinlock_t lock;
	struct blackmagic_serial_buffer write_buffer;	/* Circular write buffer */
	struct blackmagic_serial_buffer read_buffer;	/* Circular read buffer - used only when opened in IOCTL mode*/
};

struct blackmagic_device
{
	struct pci_dev *pdev;				/* Pointer to pci device */
	struct miscdevice mdev;				/* Character device for userspace communication */
	void *driver;						/* Private driver handle */
	struct tasklet_struct tasklet;		/* tasklet (critical bh) */
	struct work_struct work;			/* work handler (non-critical bh) */
	struct list_head entry;
	struct blackmagic_serial sdev;		/* Serial driver device */
	unsigned int flags;					/* Device Capablities */
	int id;                             /* Card ID */
	atomic_t ready;						/* Card state */
	atomic_t workCount;
};

#endif
